---
generated_at: 2026-01-22 13:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：129-GitLab Pages機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **Gitlab::Pages.generate_unique_domainの詳細**：ユニークドメイン生成ロジック

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/projects/pages_controller.rb` - Pagesコントローラー（93行）
- E-02: `app/services/pages/delete_service.rb` - 削除サービス（29行）
- E-03: `app/models/pages_domain.rb` - ドメインモデル（308行）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | require_pages_enabled!前提条件チェック | E-01 (4行目) | ○ |
| C-02 | authorize_read_pages!/authorize_update_pages!/authorize_remove_pages!権限チェック | E-01 (5-7行目) | ○ |
| C-03 | feature_categoryがpages | E-01 (9行目) | ○ |
| C-04 | showアクションでオンボーディングチェック | E-01 (20-22行目) | ○ |
| C-05 | showアクションでドメイン一覧取得・order(:domain) | E-01 (25-26行目) | ○ |
| C-06 | newアクションでpipeline_wizard_data設定 | E-01 (11-17行目) | ○ |
| C-07 | destroyアクションでPages::DeleteService呼び出し | E-01 (30-31行目), E-02 | ○ |
| C-08 | updateアクションでProjects::UpdateService呼び出し | E-01 (40-41行目) | ○ |
| C-09 | regenerate_unique_domainでユニークドメイン再生成 | E-01 (56-71行目) | ○ |
| C-10 | pages_unique_domain_enabled条件チェック | E-01 (57-58行目) | ○ |
| C-11 | Pages::DeleteServiceで権限チェック | E-02 (6-9行目) | ○ |
| C-12 | PagesDeployment.deactivate_all呼び出し | E-02 (11行目) | ○ |
| C-13 | PagesDomain.for_project.delete_all呼び出し | E-02 (17行目) | ○ |
| C-14 | DestroyPagesDeploymentsWorker.perform_async呼び出し | E-02 (19行目) | ○ |
| C-15 | project_params_attributesでpages_https_only等を許可 | E-01 (79-84行目) | ○ |
| C-16 | EE版でprepend_mod_with拡張 | E-01 (92行目) | ○ |
| C-17 | PagesDomainでverification_code管理 | E-03 (9, 177-189行目) | ○ |
| C-18 | Gitlab::Pages.generate_unique_domainの詳細ロジック | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Gitlab::Pagesモジュールの実装詳細が未確認
  - 候補：`lib/gitlab/pages.rb` の読み込みが必要

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラーとサービスの主要ロジックは確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Pages::DeleteServiceの削除ロジックを確認
- [ ] Gitlab::Pages.generate_unique_domainの実装を確認
- [ ] オンボーディングチェックの動作確認
- [ ] 画面機能マッピング.csvとの整合性を確認
